<?php
// @codingStandardsIgnoreStart

namespace Elementor;

/* RETURN IF ELEMENTOR IS NOT ACTIVE
***************************************************/
if( ! goto_is_elementor() ) return;


/* ADD PAGE SETTINGS
***************************************************/
add_action( 'elementor/element/wp-post/document_settings/before_section_end', 'Elementor\goto_page_settings' );
function goto_page_settings( \Elementor\Core\DocumentTypes\PageBase $page ){

    if( ! isset( $page ) ) {
    	return;
    }

    $settings_path = get_template_directory() . '/elementor/page-settings/';
    $settings = glob( $settings_path . '*.php' );

    foreach( $settings as $key ){
        if ( file_exists( $key ) ) {
            require_once $key;
        }
    }
}

/* ADD THEME WIDGETS
***************************************************/
add_action( 'elementor/widgets/widgets_registered', 'Elementor\goto_widgets' );
function goto_widgets() {
	$widgets_path = get_template_directory() . '/elementor/widgets/';
	$widgets      = glob( $widgets_path . '*.php' );

    foreach( $widgets as $key ){
        if ( file_exists( $key ) ) {
            require_once $key;
        }
    }
}

/*! ADD WIDGET CATEGORIES
------------------------------------------------->*/
add_action( 'elementor/elements/categories_registered', 'Elementor\goto_widget_categories' );
function goto_widget_categories( $elements_manager ) {
    $elements_manager->add_category(
        'goto-theme',
        array(
            'title' => esc_html__( 'Goto Theme', 'goto' )
        )
    );
}
